-- 🔧 بررسی و اصلاح جداول امنیتی
-- این فایل را در phpMyAdmin اجرا کنید

-- ایجاد جدول ip_whitelist
CREATE TABLE IF NOT EXISTS `ip_whitelist` (
    `id` INT PRIMARY KEY AUTO_INCREMENT,
    `ip_address` VARCHAR(45) NOT NULL UNIQUE,
    `description` TEXT,
    `added_by` INT,
    `is_active` BOOLEAN DEFAULT TRUE,
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    INDEX `idx_ip_address` (`ip_address`),
    INDEX `idx_is_active` (`is_active`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ایجاد جدول rate_limit_logs
CREATE TABLE IF NOT EXISTS `rate_limit_logs` (
    `id` INT PRIMARY KEY AUTO_INCREMENT,
    `ip_address` VARCHAR(45) NOT NULL,
    `endpoint` VARCHAR(255) NOT NULL,
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    INDEX `idx_ip_endpoint` (`ip_address`, `endpoint`),
    INDEX `idx_created_at` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ایجاد جدول admin_users
CREATE TABLE IF NOT EXISTS `admin_users` (
    `id` INT PRIMARY KEY AUTO_INCREMENT,
    `username` VARCHAR(50) UNIQUE NOT NULL,
    `email` VARCHAR(255) UNIQUE NOT NULL,
    `password_hash` VARCHAR(255) NOT NULL,
    `is_active` BOOLEAN DEFAULT TRUE,
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    INDEX `idx_username` (`username`),
    INDEX `idx_email` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- اضافه کردن کاربر پیش‌فرض ادمین
INSERT IGNORE INTO `admin_users` (`username`, `email`, `password_hash`) VALUES 
('admin', 'admin@example.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi');

-- اضافه کردن داده‌های نمونه برای ip_whitelist
INSERT IGNORE INTO `ip_whitelist` (`ip_address`, `description`, `added_by`) VALUES 
('127.0.0.1', 'Localhost - توسعه', 1),
('192.168.1.1', 'IP داخلی شبکه', 1),
('10.0.0.1', 'IP داخلی شرکت', 1);

-- اضافه کردن داده‌های نمونه برای rate_limit_logs
INSERT IGNORE INTO `rate_limit_logs` (`ip_address`, `endpoint`) VALUES 
('192.168.1.100', '/api/login'),
('10.0.0.50', '/api/register'),
('172.16.0.25', '/admin/dashboard');

-- نمایش وضعیت جداول
SELECT 'security_logs' as table_name, COUNT(*) as record_count FROM security_logs
UNION ALL
SELECT 'ip_blacklist' as table_name, COUNT(*) as record_count FROM ip_blacklist
UNION ALL
SELECT 'ip_whitelist' as table_name, COUNT(*) as record_count FROM ip_whitelist
UNION ALL
SELECT 'rate_limit_logs' as table_name, COUNT(*) as record_count FROM rate_limit_logs
UNION ALL
SELECT 'admin_users' as table_name, COUNT(*) as record_count FROM admin_users;
