-- 🔧 ایجاد جدول تنظیمات سیستم
-- این فایل را در phpMyAdmin اجرا کنید

-- ایجاد جدول system_settings
CREATE TABLE IF NOT EXISTS `system_settings` (
    `id` INT PRIMARY KEY AUTO_INCREMENT,
    `setting_key` VARCHAR(100) UNIQUE NOT NULL,
    `setting_value` TEXT,
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    INDEX `idx_setting_key` (`setting_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- اضافه کردن تنظیمات پیش‌فرض
INSERT IGNORE INTO `system_settings` (`setting_key`, `setting_value`) VALUES 
('rate_limit_per_hour', '5'),
('session_timeout_minutes', '30'),
('enable_xss_protection', '1'),
('enable_sql_injection_protection', '1'),
('enable_recaptcha', '1'),
('admin_email', 'info@gavahito.ir'),
('site_name', 'گواهیتو Admin Panel'),
('site_url', 'https://gavahito.ir/'),
('maintenance_mode', '0'),
('maintenance_message', 'سیستم در حال نگهداری است. لطفاً کمی صبر کنید.'),
('backup_enabled', '0'),
('backup_frequency', 'daily'),
('log_retention_days', '30'),
('max_login_attempts', '5'),
('lockout_duration_minutes', '15'),
('password_min_length', '8'),
('require_strong_password', '1'),
('twofa_enabled', '0'),
('twofa_code_expiry', '300'),
('email_notifications', '1'),
('auto_logout_minutes', '30'),
('favicon_path', 'assets/favicons/favicon.ico'),
('email_alerts', '1'),
('email_recipient', 'raytheme.ir@gmail.com'),
('email_alert_level', 'medium'),
('email_frequency', 'immediate'),
('email_from', 'info@gavahito.ir'),
('email_from_name', 'گواهیتو Security System');

-- نمایش وضعیت جدول
SELECT 'system_settings' as table_name, COUNT(*) as record_count FROM system_settings;
