-- Feature Suggestions and Votes Tables
-- جداول پیشنهادات عمومی و رای‌ها

-- Public Feature Suggestions Table (مدیریت شده توسط ادمین)
CREATE TABLE IF NOT EXISTS public_feature_suggestions (
    id INT AUTO_INCREMENT PRIMARY KEY,
    title VARCHAR(200) NOT NULL,
    description TEXT NOT NULL,
    is_active BOOLEAN DEFAULT TRUE,
    is_featured BOOLEAN DEFAULT FALSE,
    display_order INT DEFAULT 0,
    created_by INT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP NULL ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (created_by) REFERENCES admin_users(id) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Feature Votes Table (رای‌های کاربران)
CREATE TABLE IF NOT EXISTS feature_votes (
    id INT AUTO_INCREMENT PRIMARY KEY,
    suggestion_id INT NOT NULL,
    ip_address VARCHAR(45) NOT NULL,
    user_agent TEXT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (suggestion_id) REFERENCES public_feature_suggestions(id) ON DELETE CASCADE,
    UNIQUE KEY unique_vote (suggestion_id, ip_address)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Indexes (با بررسی وجود قبلی)
-- Indexes (with existence check)
CREATE INDEX idx_suggestions_active ON public_feature_suggestions(is_active);
CREATE INDEX idx_suggestions_featured ON public_feature_suggestions(is_featured);
CREATE INDEX idx_suggestions_order ON public_feature_suggestions(display_order);
CREATE INDEX idx_votes_suggestion ON feature_votes(suggestion_id);
CREATE INDEX idx_votes_ip ON feature_votes(ip_address);

