-- ایجاد جداول ضروری برای تشخیص تهدید

-- جدول تنظیمات تشخیص تهدید
CREATE TABLE IF NOT EXISTS `threat_detection_settings` (
    `id` INT PRIMARY KEY AUTO_INCREMENT,
    `setting_key` VARCHAR(50) UNIQUE NOT NULL,
    `setting_value` TEXT NOT NULL,
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- درج تنظیمات پیش‌فرض
INSERT INTO `threat_detection_settings` (`setting_key`, `setting_value`) VALUES
('auto_block_enabled', '1'),
('risk_threshold', '80'),
('geographic_risk_enabled', '1'),
('email_alerts', '1')
ON DUPLICATE KEY UPDATE `setting_value` = VALUES(`setting_value`);

-- جدول لاگ‌های امنیتی (اگر وجود نداشته باشد)
CREATE TABLE IF NOT EXISTS `security_logs` (
    `id` INT PRIMARY KEY AUTO_INCREMENT,
    `event_type` VARCHAR(50) NOT NULL,
    `ip_address` VARCHAR(45) NOT NULL,
    `user_agent` TEXT,
    `request_data` TEXT,
    `details` TEXT,
    `severity` ENUM('low', 'medium', 'high', 'critical') DEFAULT 'medium',
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    INDEX `idx_ip_address` (`ip_address`),
    INDEX `idx_created_at` (`created_at`),
    INDEX `idx_severity` (`severity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- جدول لیست سیاه IP (اگر وجود نداشته باشد)
CREATE TABLE IF NOT EXISTS `ip_blacklist` (
    `id` INT PRIMARY KEY AUTO_INCREMENT,
    `ip_address` VARCHAR(45) NOT NULL UNIQUE,
    `reason` TEXT,
    `blocked_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    `expires_at` TIMESTAMP NULL,
    `is_active` BOOLEAN DEFAULT TRUE,
    INDEX `idx_ip_address` (`ip_address`),
    INDEX `idx_expires_at` (`expires_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- درج چند نمونه لاگ برای تست
INSERT INTO `security_logs` (`event_type`, `ip_address`, `user_agent`, `request_data`, `details`, `severity`) VALUES
('suspicious_activity', '192.168.1.100', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36', 'POST /login', 'Multiple failed login attempts', 'high'),
('sql_injection', '8.8.8.8', 'curl/7.68.0', 'GET /search?q=1\' OR 1=1--', 'SQL injection attempt detected', 'critical'),
('xss_attempt', '1.1.1.1', 'python-requests/2.25.1', 'POST /comment', 'XSS attack attempt', 'high'),
('brute_force', '127.0.0.1', 'Mozilla/5.0 (compatible; Bot)', 'POST /admin/login', 'Brute force attack detected', 'critical'),
('file_upload_attempt', '10.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36', 'POST /upload', 'Suspicious file upload', 'medium')
ON DUPLICATE KEY UPDATE `created_at` = CURRENT_TIMESTAMP;

-- جدول لاگ‌های ایمیل
CREATE TABLE IF NOT EXISTS `email_logs` (
    `id` INT PRIMARY KEY AUTO_INCREMENT,
    `recipient` VARCHAR(255) NOT NULL,
    `subject` VARCHAR(500) NOT NULL,
    `severity` ENUM('low', 'medium', 'high', 'critical') DEFAULT 'medium',
    `sent_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    INDEX `idx_recipient` (`recipient`),
    INDEX `idx_sent_at` (`sent_at`),
    INDEX `idx_severity` (`severity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- نمایش وضعیت جداول
SELECT 'threat_detection_settings' as table_name, COUNT(*) as record_count FROM threat_detection_settings
UNION ALL
SELECT 'security_logs' as table_name, COUNT(*) as record_count FROM security_logs
UNION ALL
SELECT 'ip_blacklist' as table_name, COUNT(*) as record_count FROM ip_blacklist
UNION ALL
SELECT 'email_logs' as table_name, COUNT(*) as record_count FROM email_logs;
