<!-- Favicon -->
<link rel="icon" type="image/png" href="assets/images/logo.png">

<!-- Inline CSS for Glassmorphism Sidebar -->
<style>
    @import url('https://fonts.googleapis.com/css2?family=Vazirmatn:wght@300;400;500;600;700&display=swap');
    
    :root {
        /* Gold colors (primary) - matching landing page */
        --primary-50: #fef9f0;
        --primary-100: #fef3e0;
        --primary-200: #fce7c1;
        --primary-300: #f9d5a3;
        --primary-400: #f5c175;
        --primary-500: #c5912c;
        --primary-600: #b08226;
        --primary-700: #9a6f20;
        --primary-800: #845c1a;
        --primary-900: #6e4914;
        
        /* Dark blue colors (secondary) - matching landing page */
        --secondary-50: #e8eef5;
        --secondary-100: #d1ddeb;
        --secondary-200: #a3bbe7;
        --secondary-300: #7599d3;
        --secondary-400: #4777bf;
        --secondary-500: #041c3f;
        --secondary-600: #03162f;
        --secondary-700: #02101f;
        --secondary-800: #010a0f;
        --secondary-900: #000400;
        
        /* Dark theme colors based on landing page */
        --dark-50: #f0f4f8;
        --dark-100: #d9e2ec;
        --dark-200: #bcccdc;
        --dark-300: #9fb3c8;
        --dark-400: #829ab1;
        --dark-500: #627d98;
        --dark-600: #486581;
        --dark-700: #334e68;
        --dark-800: #243b53;
        --dark-900: #041c3f;
        
        /* Accent colors - using gold */
        --accent-50: #fef9f0;
        --accent-100: #fef3e0;
        --accent-200: #fce7c1;
        --accent-300: #f9d5a3;
        --accent-400: #f5c175;
        --accent-500: #c5912c;
        --accent-600: #b08226;
        --accent-700: #9a6f20;
        --accent-800: #845c1a;
        --accent-900: #6e4914;
        
        --sidebar-width: 280px;
        --sidebar-width-mobile: 320px;
    }
    
    * {
        margin: 0;
        padding: 0;
        box-sizing: border-box;
    }
    
    body {
        font-family: 'Vazirmatn', sans-serif;
        background: linear-gradient(135deg, #041c3f 0%, #022847 50%, #041c3f 100%);
        color: var(--dark-100);
        direction: rtl;
        min-height: 100vh;
        overflow-x: hidden;
    }
    
    /* Header Styles */
    .admin-header {
        background: rgba(255, 255, 255, 0.1);
        backdrop-filter: blur(20px);
        -webkit-backdrop-filter: blur(20px);
        border-bottom: 1px solid rgba(255, 255, 255, 0.2);
        box-shadow: 0 8px 32px rgba(0, 0, 0, 0.1);
        padding: 1rem 2rem;
        position: sticky;
        top: 0;
        z-index: 50;
    }
    
    /* Mobile Header Glassmorphism */
    @media (max-width: 768px) {
        .admin-header {
            background: rgba(255, 255, 255, 0.15);
            backdrop-filter: blur(25px);
            -webkit-backdrop-filter: blur(25px);
            border-bottom: 1px solid rgba(255, 255, 255, 0.3);
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.15);
        }
    }
    
    .header-content {
        display: flex;
        justify-content: space-between;
        align-items: center;
        max-width: 1200px;
        margin: 0 auto;
    }
    
    .logo {
        font-size: 1.5rem;
        font-weight: 700;
        color: white;
        text-decoration: none;
    }
    
    .mobile-menu-toggle {
        display: none;
        flex-direction: column;
        cursor: pointer;
        gap: 4px;
        padding: 8px;
        border-radius: 8px;
        background: rgba(255, 255, 255, 0.1);
        transition: all 0.3s ease;
    }
    
    .mobile-menu-toggle span {
        width: 25px;
        height: 3px;
        background: white;
        border-radius: 2px;
        transition: all 0.3s ease;
    }
    
    .mobile-menu-toggle:hover {
        background: rgba(255, 255, 255, 0.2);
    }
    
    .user-menu {
        display: flex;
        align-items: center;
        gap: 1rem;
    }
    
    .user-info {
        color: white;
        font-weight: 500;
    }
    
    .logout-btn {
        background: rgba(255, 255, 255, 0.1);
        color: white;
        border: 1px solid rgba(255, 255, 255, 0.2);
        padding: 0.5rem 1rem;
        border-radius: 0.5rem;
        text-decoration: none;
        transition: all 0.3s ease;
    }
    
    .logout-btn:hover {
        background: rgba(255, 255, 255, 0.2);
        transform: translateY(-2px);
    }
    
    /* Glassmorphism Sidebar */
    .glassmorphism-sidebar {
        position: fixed;
        top: 0;
        right: 0;
        width: var(--sidebar-width);
        height: 100vh;
        background: rgba(255, 255, 255, 0.1);
        backdrop-filter: blur(20px);
        -webkit-backdrop-filter: blur(20px);
        border-left: 1px solid rgba(255, 255, 255, 0.2);
        box-shadow: -10px 0 30px rgba(0, 0, 0, 0.3);
        z-index: 1000;
        transition: transform 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        display: flex;
        flex-direction: column;
    }
    
    /* Desktop: Show sidebar by default */
    @media (min-width: 1025px) {
        .glassmorphism-sidebar {
            transform: translateX(0);
        }
    }
    
    /* Mobile: Hide sidebar by default */
    @media (max-width: 1024px) {
        .glassmorphism-sidebar {
            transform: translateX(100%);
        }
        
        .glassmorphism-sidebar.active {
            transform: translateX(0);
        }
    }
    
    .sidebar-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        padding: 1.5rem;
        border-bottom: 1px solid rgba(255, 255, 255, 0.1);
    }
    
    .sidebar-logo {
        display: flex;
        align-items: center;
        gap: 0.75rem;
    }
    
    .logo-icon {
        font-size: 1.5rem;
        background: linear-gradient(135deg, #c5912c, #041c3f);
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        background-clip: text;
    }
    
    .logo-image {
        width: 2.5rem;
        height: 2.5rem;
        object-fit: contain;
        border-radius: 0.5rem;
        filter: brightness(0) invert(1); /* Make logo white */
        transition: all 0.3s ease;
    }
    
    .logo-image:hover {
        transform: scale(1.1);
        filter: brightness(1) invert(0); /* Show original colors on hover */
    }
    
    .logo-text {
        font-size: 1.25rem;
        font-weight: 700;
        color: white;
    }
    
    .sidebar-close {
        display: none;
        background: none;
        border: none;
        color: white;
        font-size: 1.5rem;
        cursor: pointer;
        padding: 0.5rem;
        border-radius: 0.5rem;
        transition: all 0.3s ease;
    }
    
    /* Show close button on mobile */
    @media (max-width: 1024px) {
        .sidebar-close {
            display: block;
        }
    }
    
    .sidebar-close:hover {
        background: rgba(255, 255, 255, 0.1);
    }
    
    .sidebar-nav {
        flex: 1;
        padding: 1rem 0;
        overflow-y: auto;
    }
    
    .sidebar-menu {
        list-style: none;
        padding: 0;
        margin: 0;
    }
    
    .sidebar-item {
        margin: 0.25rem 1rem;
    }
    
    .sidebar-link {
        display: flex;
        align-items: center;
        gap: 0.75rem;
        padding: 0.75rem 1rem;
        color: rgba(255, 255, 255, 0.8);
        text-decoration: none;
        border-radius: 0.75rem;
        transition: all 0.3s ease;
        position: relative;
        overflow: hidden;
    }
    
    .sidebar-link::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: linear-gradient(135deg, rgba(255, 255, 255, 0.1), rgba(255, 255, 255, 0.05));
        opacity: 0;
        transition: opacity 0.3s ease;
        border-radius: 0.75rem;
    }
    
    .sidebar-link:hover::before {
        opacity: 1;
    }
    
    .sidebar-link:hover {
        color: white;
        transform: translateX(-4px);
    }
    
    .sidebar-item.active .sidebar-link {
        background: linear-gradient(135deg, #c5912c, #b08226);
        color: white;
        box-shadow: 0 4px 15px rgba(197, 145, 44, 0.3);
    }
    
    .sidebar-item.active .sidebar-link::before {
        display: none;
    }
    
    .sidebar-icon {
        font-size: 1.25rem;
        min-width: 1.5rem;
        text-align: center;
    }
    
    .sidebar-text {
        font-weight: 500;
        flex: 1;
    }
    
    .sidebar-badge {
        background: #c5912c;
        color: white;
        font-size: 0.75rem;
        font-weight: 600;
        padding: 0.25rem 0.5rem;
        border-radius: 9999px;
        min-width: 1.5rem;
        text-align: center;
    }
    
    .sidebar-badge.warning {
        background: #f59e0b;
    }
    
    .sidebar-footer {
        padding: 1.5rem;
        border-top: 1px solid rgba(255, 255, 255, 0.1);
    }
    
    .user-profile {
        display: flex;
        align-items: center;
        gap: 0.75rem;
        padding: 1rem;
        background: rgba(255, 255, 255, 0.05);
        border-radius: 0.75rem;
        border: 1px solid rgba(255, 255, 255, 0.1);
    }
    
    .user-avatar {
        width: 3rem;
        height: 3rem;
        background: linear-gradient(135deg, #c5912c, #041c3f);
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 1.25rem;
    }
    
    .user-details {
        flex: 1;
    }
    
    .user-name {
        color: white;
        font-weight: 600;
        font-size: 0.9rem;
    }
    
    .user-role {
        color: rgba(255, 255, 255, 0.6);
        font-size: 0.8rem;
        margin-top: 0.25rem;
    }
    
    /* Main Content */
    .main-content {
        margin-right: var(--sidebar-width);
        max-width: calc(1200px + var(--sidebar-width));
        margin-left: auto;
        padding: 2rem;
        transition: margin-right 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    }
    
    .page-header {
        background: linear-gradient(135deg, #041c3f 0%, #022847 100%);
        border-radius: 1rem;
        padding: 2rem;
        margin-bottom: 2rem;
        box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
    }
    
    .page-title {
        font-size: 2rem;
        font-weight: 700;
        color: #c5912c;
        margin-bottom: 0.5rem;
    }
    
    .page-description {
        color: var(--dark-300);
        font-size: 1.1rem;
    }
    
    /* Card Styles */
    .card {
        background: linear-gradient(135deg, #041c3f 0%, #022847 100%);
        border-radius: 1rem;
        padding: 2rem;
        margin-bottom: 2rem;
        box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
        border: 1px solid rgba(197, 145, 44, 0.2);
    }
    
    /* Table Container */
    .table-container {
        font-size: 0.875rem;
        overflow-x: auto;
        -webkit-overflow-scrolling: touch;
        border-radius: 0.5rem;
        background: #022847;
        border: 1px solid rgba(197, 145, 44, 0.2);
    }
    
    .table {
        width: 100%;
        border-collapse: collapse;
        background: #041c3f;
        border-radius: 0.5rem;
        overflow: hidden;
    }
    
    .table th {
        background: #022847;
        color: #c5912c;
        font-weight: 600;
        padding: 1rem;
        text-align: right;
        border-bottom: 1px solid rgba(197, 145, 44, 0.2);
    }
    
    .table td {
        padding: 1rem;
        border-bottom: 1px solid rgba(197, 145, 44, 0.2);
        color: var(--dark-200);
    }
    
    .table tr:hover {
        background: #022847;
    }
    
    .table tr:last-child td {
        border-bottom: none;
    }
    
    .card-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 1.5rem;
        padding-bottom: 1rem;
        border-bottom: 1px solid var(--dark-600);
    }
    
    .card-title {
        font-size: 1.5rem;
        font-weight: 600;
        color: #c5912c;
    }
    
    /* Button Styles */
    .btn {
        display: inline-flex;
        align-items: center;
        justify-content: center;
        padding: 0.75rem 1.5rem;
        border: none;
        border-radius: 0.5rem;
        font-family: inherit;
        font-weight: 500;
        text-decoration: none;
        cursor: pointer;
        transition: all 0.3s ease;
        gap: 0.5rem;
    }
    
    .btn-primary {
        background: linear-gradient(135deg, #c5912c 0%, #b08226 100%);
        color: white;
    }
    
    .btn-primary:hover {
        background: linear-gradient(135deg, #b08226 0%, #9a6f20 100%);
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(197, 145, 44, 0.3);
    }
    
    .btn-secondary {
        background: linear-gradient(135deg, #041c3f 0%, #03162f 100%);
        color: white;
    }
    
    .btn-secondary:hover {
        background: linear-gradient(135deg, #03162f 0%, #02101f 100%);
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(4, 28, 63, 0.3);
    }
    
    .btn-success {
        background: linear-gradient(135deg, #10b981 0%, #059669 100%);
        color: white;
    }
    
    .btn-success:hover {
        background: linear-gradient(135deg, #059669 0%, #047857 100%);
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(16, 185, 129, 0.3);
    }
    
    .btn-danger {
        background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%);
        color: white;
    }
    
    .btn-danger:hover {
        background: linear-gradient(135deg, #dc2626 0%, #b91c1c 100%);
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(239, 68, 68, 0.3);
    }
    
    .btn-warning {
        background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%);
        color: white;
    }
    
    .btn-warning:hover {
        background: linear-gradient(135deg, #d97706 0%, #b45309 100%);
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(245, 158, 11, 0.3);
    }
    
    .btn-info {
        background: linear-gradient(135deg, #b08226 0%, #9a6f20 100%);
        color: white;
    }
    
    .btn-info:hover {
        background: linear-gradient(135deg, #9a6f20 0%, #845c1a 100%);
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(197, 145, 44, 0.3);
    }
    
    .btn-sm {
        padding: 0.5rem 1rem;
        font-size: 0.875rem;
    }
    
    .btn-lg {
        padding: 1rem 2rem;
        font-size: 1.125rem;
    }
    
    /* Form Styles */
    .form-group {
        margin-bottom: 1.5rem;
    }
    
    .form-label {
        display: block;
        margin-bottom: 0.5rem;
        font-weight: 500;
        color: var(--dark-200);
    }
    
    .form-input {
        width: 100%;
        padding: 0.75rem 1rem;
        border: 1px solid var(--dark-600);
        border-radius: 0.5rem;
        background: var(--dark-700);
        color: var(--dark-100);
        font-family: inherit;
        transition: all 0.3s ease;
    }
    
    .form-input:focus {
        outline: none;
        border-color: #c5912c;
        box-shadow: 0 0 0 3px rgba(197, 145, 44, 0.1);
    }
    
    .form-select {
        width: 100%;
        padding: 0.75rem 1rem;
        border: 1px solid var(--dark-600);
        border-radius: 0.5rem;
        background: var(--dark-700);
        color: var(--dark-100);
        font-family: inherit;
        cursor: pointer;
    }
    
    .form-textarea {
        width: 100%;
        padding: 0.75rem 1rem;
        border: 1px solid var(--dark-600);
        border-radius: 0.5rem;
        background: var(--dark-700);
        color: var(--dark-100);
        font-family: inherit;
        resize: vertical;
        min-height: 120px;
    }
    
    /* Table Styles */
    .table-container {
        overflow-x: auto;
        border-radius: 0.5rem;
        border: 1px solid var(--dark-600);
    }
    
    .table {
        width: 100%;
        border-collapse: collapse;
        background: var(--dark-800);
    }
    
    .table th,
    .table td {
        padding: 1rem;
        text-align: right;
        border-bottom: 1px solid var(--dark-600);
    }
    
    .table th {
        background: #022847;
        font-weight: 600;
        color: #c5912c;
        position: sticky;
        top: 0;
    }
    
    .table tr:hover {
        background: #022847;
    }
    
    .table tr:last-child td {
        border-bottom: none;
    }
    
    /* Badge Styles */
    .badge {
        display: inline-block;
        padding: 0.25rem 0.75rem;
        border-radius: 9999px;
        font-size: 0.75rem;
        font-weight: 500;
    }
    
    .badge-primary {
        background: var(--primary-100);
        color: var(--primary-800);
    }
    
    .badge-secondary {
        background: var(--secondary-100);
        color: var(--secondary-800);
    }
    
    .badge-success {
        background: #dcfce7;
        color: #166534;
    }
    
    .badge-danger {
        background: #fee2e2;
        color: #991b1b;
    }
    
    .badge-warning {
        background: #fef3c7;
        color: #92400e;
    }
    
    .badge-info {
        background: var(--accent-100);
        color: var(--accent-800);
    }
    
    /* Alert Styles */
    .alert {
        padding: 1rem 1.5rem;
        border-radius: 0.5rem;
        margin-bottom: 1.5rem;
        border: 1px solid transparent;
    }
    
    .alert-success {
        background: #dcfce7;
        color: #166534;
        border-color: #bbf7d0;
    }
    
    .alert-danger {
        background: #fee2e2;
        color: #991b1b;
        border-color: #fecaca;
    }
    
    .alert-warning {
        background: #fef3c7;
        color: #92400e;
        border-color: #fed7aa;
    }
    
    .alert-info {
        background: var(--accent-100);
        color: var(--accent-800);
        border-color: var(--accent-200);
    }
    
    /* Grid System */
    .grid {
        display: grid;
        gap: 2rem;
    }
    
    .grid-cols-1 { grid-template-columns: repeat(1, 1fr); }
    .grid-cols-2 { grid-template-columns: repeat(2, 1fr); }
    .grid-cols-3 { grid-template-columns: repeat(3, 1fr); }
    .grid-cols-4 { grid-template-columns: repeat(4, 1fr); }
    
    /* Stats Cards */
    .stats-card {
        background: linear-gradient(135deg, #041c3f 0%, #022847 100%);
        border-radius: 1rem;
        padding: 2rem;
        text-align: center;
        border: 1px solid rgba(197, 145, 44, 0.2);
        transition: all 0.3s ease;
    }
    
    .stats-card:hover {
        transform: translateY(-4px);
        box-shadow: 0 8px 25px rgba(0, 0, 0, 0.2);
    }
    
    .stats-number {
        font-size: 2.5rem;
        font-weight: 700;
        color: #c5912c;
        margin-bottom: 0.5rem;
    }
    
    .stats-label {
        color: var(--dark-300);
        font-size: 1rem;
        font-weight: 500;
    }
    
    /* Desktop Header */
    .desktop-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        width: 100%;
    }
    
    /* Mobile Header */
    .mobile-header {
        display: none;
        justify-content: space-between;
        align-items: center;
        width: 100%;
    }
    
    .mobile-logo {
        font-size: 2rem;
        color: white;
        text-align: center;
        flex: 1;
    }
    
    .mobile-user-info {
        display: flex;
        flex-direction: column;
        align-items: flex-start;
        gap: 0.25rem;
    }
    
    .mobile-username {
        color: white;
        font-size: 0.875rem;
        font-weight: 500;
    }
    
    .mobile-logout {
        color: white;
        font-size: 0.75rem;
        text-decoration: none;
        opacity: 0.8;
        transition: opacity 0.3s ease;
    }
    
    .mobile-logout:hover {
        opacity: 1;
    }
    
    /* Responsive Design */
    @media (max-width: 768px) {
        .admin-header {
            padding: 0.75rem 1rem;
        }
        
        .header-content {
            flex-direction: row;
            gap: 0.5rem;
        }
        
        /* Hide desktop header, show mobile header */
        .desktop-header {
            display: none;
        }
        
        .mobile-header {
            display: flex;
        }
        
        .mobile-menu-toggle {
            display: flex;
        }
        
        .glassmorphism-sidebar {
            width: var(--sidebar-width-mobile);
        }
        
        .sidebar-close {
            display: block;
        }
        
        .main-content {
            margin-right: 0;
            padding: 1rem;
        }
        
        .grid-cols-2,
        .grid-cols-3,
        .grid-cols-4 {
            grid-template-columns: 1fr;
        }
        
        .table-container {
            font-size: 0.875rem;
        }
        
        .table th,
        .table td {
            padding: 0.75rem 0.5rem;
        }
        
        /* Mobile sidebar overlay */
        body.sidebar-open::before {
            content: '';
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0, 0, 0, 0.5);
            z-index: 999;
            backdrop-filter: blur(4px);
        }
        
        /* Mobile card improvements */
        .card {
            margin-bottom: 1rem;
            border-radius: 12px;
        }
        
        .card-header {
            padding: 1rem;
        }
        
        .card-body {
            padding: 1rem;
        }
        
        /* Mobile button improvements */
        .btn {
            padding: 0.75rem 1rem;
            font-size: 0.875rem;
        }
        
        .btn-lg {
            padding: 1rem 1.5rem;
            font-size: 1rem;
        }
        
        /* Mobile table improvements */
        .table-responsive {
            overflow-x: auto;
            -webkit-overflow-scrolling: touch;
        }
        
        .table {
            min-width: 600px;
        }
    }
    
    /* Fade In Animation */
    .fade-in {
        animation: fadeIn 0.5s ease-out;
    }
    
    @keyframes fadeIn {
        from {
            opacity: 0;
            transform: translateY(20px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }
    
    /* Custom Scrollbar */
    ::-webkit-scrollbar {
        width: 8px;
    }
    
    ::-webkit-scrollbar-track {
        background: var(--dark-800);
    }
    
    ::-webkit-scrollbar-thumb {
        background: var(--dark-600);
        border-radius: 4px;
    }
    
    ::-webkit-scrollbar-thumb:hover {
        background: var(--dark-500);
    }
    
    /* Sidebar scrollbar */
    .sidebar-nav::-webkit-scrollbar {
        width: 4px;
    }
    
    .sidebar-nav::-webkit-scrollbar-track {
        background: transparent;
    }
    
    .sidebar-nav::-webkit-scrollbar-thumb {
        background: rgba(255, 255, 255, 0.2);
        border-radius: 2px;
    }
    
    .sidebar-nav::-webkit-scrollbar-thumb:hover {
        background: rgba(255, 255, 255, 0.3);
    }
    
    /* Responsive Design */
    @media (max-width: 1024px) {
        .main-content {
            margin-right: 0;
            padding: 1.5rem;
        }
        
        .page-header {
            margin-bottom: 1.5rem;
        }
        
        .page-title {
            font-size: 1.5rem;
        }
        
        .page-description {
            font-size: 0.875rem;
        }
    }
    
    @media (max-width: 768px) {
        .main-content {
            padding: 1rem;
            margin-top: 0;
            margin-right: 0;
        }
        
        .page-header {
            margin-bottom: 1rem;
            text-align: center;
            padding: 1.5rem;
        }
        
        .page-title {
            font-size: 1.25rem;
            margin-bottom: 0.5rem;
        }
        
        .page-description {
            font-size: 0.8rem;
            opacity: 0.8;
        }
        
        .admin-header {
            padding: 0.75rem 1rem;
        }
        
        .header-content {
            padding: 0;
        }
        
        .desktop-header {
            display: none;
        }
        
        .mobile-header {
            display: flex;
        }
        
        .mobile-menu-toggle {
            display: flex;
        }
        
        .mobile-logo {
            display: flex;
            align-items: center;
            justify-content: center;
            flex: 1;
        }
        
        .mobile-logo img {
            width: 54px;
            height: 54px;
            border-radius: 6px;
            filter: none; /* Show original colors */
        }
        
        .mobile-user-info {
            display: flex;
            flex-direction: column;
            align-items: flex-end;
            gap: 0.25rem;
        }
        
        .mobile-username {
            font-size: 0.875rem;
            color: white;
            font-weight: 500;
        }
        
        .mobile-logout {
            font-size: 0.75rem;
            color: rgba(255, 255, 255, 0.8);
            text-decoration: none;
            padding: 0.25rem 0.5rem;
            border-radius: 4px;
            background: rgba(255, 255, 255, 0.1);
            transition: all 0.3s ease;
        }
        
        .mobile-logout:hover {
            background: rgba(255, 255, 255, 0.2);
        }
        
        .card {
            padding: 1.5rem;
            margin-bottom: 1.5rem;
            overflow: hidden;
        }
        
        .card-header {
            margin-bottom: 1rem;
        }
        
        .card-title {
            font-size: 1.25rem;
        }
        
        .card-body {
            overflow-x: auto;
            -webkit-overflow-scrolling: touch;
        }
        
        .table {
            min-width: 600px;
            font-size: 0.875rem;
        }
        
        .table th,
        .table td {
            padding: 0.5rem;
            white-space: nowrap;
        }
        
        .grid-cols-2,
        .grid-cols-3,
        .grid-cols-4 {
            grid-template-columns: 1fr;
            gap: 1rem;
        }
        
        .stats-card {
            padding: 1.5rem;
        }
        
        .stats-number {
            font-size: 2rem;
        }
        
        .stats-label {
            font-size: 0.875rem;
        }
        
        /* Sidebar responsive */
        .glassmorphism-sidebar {
            transform: translateX(100%);
            width: var(--sidebar-width-mobile);
        }
        
        .glassmorphism-sidebar.active {
            transform: translateX(0);
        }
    }
    
    @media (max-width: 480px) {
        .main-content {
            padding: 0.75rem;
        }
        
        .page-header {
            margin-bottom: 0.75rem;
            padding: 1rem;
        }
        
        .page-title {
            font-size: 1.125rem;
        }
        
        .page-description {
            font-size: 0.75rem;
        }
        
        .admin-header {
            padding: 0.5rem 0.75rem;
        }
        
        .mobile-logo img {
            width: 54px;
            height: 54px;
            filter: none; /* Show original colors */
        }
        
        .card {
            padding: 1rem;
            margin-bottom: 1rem;
        }
        
        .card-title {
            font-size: 1.125rem;
        }
        
        .card-body {
            padding: 0.75rem;
        }
        
        .table {
            min-width: 500px;
            font-size: 0.8rem;
        }
        
        .table th,
        .table td {
            padding: 0.5rem;
        }
        
        .stats-card {
            padding: 1rem;
        }
        
        .stats-number {
            font-size: 1.75rem;
        }
        
        .stats-label {
            font-size: 0.8rem;
        }
        
        .glassmorphism-sidebar {
            width: 100%;
            max-width: 320px;
        }
        
        .sidebar-header {
            padding: 0.75rem;
        }
        
        .sidebar-logo {
            font-size: 1rem;
        }
        
        .sidebar-nav {
            padding: 0.75rem;
        }
        
        .sidebar-link {
            padding: 0.5rem 0.75rem;
            font-size: 0.8rem;
        }
        
        .sidebar-icon {
            font-size: 0.875rem;
        }
        
        .sidebar-footer {
            padding: 0.75rem;
        }
        
        .user-profile {
            padding: 0.5rem;
        }
        
        .user-name {
            font-size: 0.875rem;
        }
        
        .user-role {
            font-size: 0.75rem;
        }
    }
</style>

<script>
    // Add fade-in animation to cards
    document.addEventListener('DOMContentLoaded', function() {
        const cards = document.querySelectorAll('.card, .stats-card');
        cards.forEach((card, index) => {
            card.style.animationDelay = (index * 0.1) + 's';
            card.classList.add('fade-in');
        });
        
        // Sidebar functionality for all pages
        const mobileMenuToggle = document.getElementById('mobileMenuToggle');
        const sidebar = document.getElementById('sidebar');
        const sidebarClose = document.getElementById('sidebarClose');
        const sidebarOverlay = document.getElementById('sidebarOverlay');
        
        // Check if we're on mobile
        function isMobile() {
            return window.innerWidth <= 1024;
        }
        
        // Toggle sidebar and overlay
        function toggleSidebar() {
            if (sidebar && sidebarOverlay) {
                const isActive = sidebar.classList.contains('active');
                if (isActive) {
                    sidebar.classList.remove('active');
                    sidebarOverlay.classList.remove('active');
                } else {
                    sidebar.classList.add('active');
                    sidebarOverlay.classList.add('active');
                }
            }
        }
        
        // Close sidebar and overlay
        function closeSidebar() {
            if (sidebar && sidebarOverlay) {
                sidebar.classList.remove('active');
                sidebarOverlay.classList.remove('active');
            }
        }
        
        // Initialize sidebar state
        if (sidebar) {
            if (isMobile()) {
                sidebar.classList.remove('active');
                if (sidebarOverlay) sidebarOverlay.classList.remove('active');
            } else {
                sidebar.classList.add('active');
                if (sidebarOverlay) sidebarOverlay.classList.remove('active');
            }
        }
        
        if (mobileMenuToggle && sidebar) {
            mobileMenuToggle.addEventListener('click', function(e) {
                e.preventDefault();
                e.stopPropagation();
                toggleSidebar();
            });
            
            // Add touch event for better mobile support
            mobileMenuToggle.addEventListener('touchstart', function(e) {
                e.preventDefault();
                e.stopPropagation();
                toggleSidebar();
            });
        }
        
        if (sidebarClose && sidebar) {
            sidebarClose.addEventListener('click', function(e) {
                e.preventDefault();
                e.stopPropagation();
                closeSidebar();
            });
        }
        
        // Close sidebar when clicking overlay
        if (sidebarOverlay) {
            sidebarOverlay.addEventListener('click', function() {
                closeSidebar();
            });
        }
        
        // Close sidebar when clicking outside on mobile
        document.addEventListener('click', function(e) {
            if (sidebar && sidebar.classList.contains('active') && isMobile()) {
                if (!sidebar.contains(e.target) && !mobileMenuToggle.contains(e.target)) {
                    closeSidebar();
                }
            }
        });
        
        // Handle window resize
        window.addEventListener('resize', function() {
            if (sidebar) {
                if (isMobile()) {
                    sidebar.classList.remove('active');
                    if (sidebarOverlay) sidebarOverlay.classList.remove('active');
                } else {
                    sidebar.classList.add('active');
                    if (sidebarOverlay) sidebarOverlay.classList.remove('active');
                }
            }
        });
    });
</script>
