<?php
/**
 * Email Configuration for گواهیتو Admin Panel
 * تنظیمات ایمیل برای پنل مدیریت گواهیتو
 */

// Email Settings - تنظیمات ایمیل
define('ADMIN_EMAIL', 'raytheme.ir@gmail.com'); // آدرس ایمیل ادمین - گیرنده
define('ADMIN_NAME', 'تیم پشتیبانی گواهیتو'); // نام ادمین
define('SITE_NAME', 'گواهیتو'); // نام سایت
define('SITE_URL', 'https://gavahito.ir/'); // آدرس سایت
define('FROM_EMAIL', 'info@gavahito.ir'); // آدرس ایمیل فرستنده

// Email Templates - قالب‌های ایمیل
define('EMAIL_ENABLED', true); // فعال/غیرفعال کردن ارسال ایمیل

// Email Headers - هدرهای ایمیل با بهبود ضد اسپم
function getEmailHeaders($replyTo = '') {
    $headers = array();
    $headers[] = 'MIME-Version: 1.0';
    $headers[] = 'Content-Type: text/html; charset=UTF-8';
    $headers[] = 'From: ' . SITE_NAME . ' <' . FROM_EMAIL . '>';
    
    if (!empty($replyTo)) {
        $headers[] = 'Reply-To: ' . $replyTo;
    } else {
        $headers[] = 'Reply-To: ' . FROM_EMAIL;
    }
    
    // Anti-spam headers - هدرهای ضد اسپم
    $headers[] = 'X-Mailer: Gavahito Mail System';
    $headers[] = 'X-Priority: 3';
    $headers[] = 'X-MSMail-Priority: Normal';
    $headers[] = 'Importance: Normal';
    $headers[] = 'List-Unsubscribe: <mailto:' . FROM_EMAIL . '?subject=Unsubscribe>';
    $headers[] = 'List-Unsubscribe-Post: List-Unsubscribe=One-Click';
    $headers[] = 'Precedence: bulk';
    $headers[] = 'Auto-Submitted: auto-generated';
    
    return implode("\r\n", $headers);
}

// Email Priority Colors - رنگ‌های اولویت
function getPriorityColor($priority) {
    $colors = [
        'low' => '#27ae60',
        'medium' => '#f39c12', 
        'high' => '#e74c3c',
        'critical' => '#8e44ad'
    ];
    return $colors[$priority] ?? '#f39c12';
}

// Email Priority Labels - برچسب‌های اولویت
function getPriorityLabel($priority) {
    $labels = [
        'low' => 'کم',
        'medium' => 'متوسط',
        'high' => 'زیاد', 
        'critical' => 'بحرانی'
    ];
    return $labels[$priority] ?? 'متوسط';
}

// Send Email Function - تابع ارسال ایمیل
function sendEmail($to, $subject, $message, $replyTo = '', $attachmentPath = null) {
    if (!EMAIL_ENABLED) {
        return false;
    }
    
    $headers = getEmailHeaders($replyTo);
    
    // Add HTML wrapper with improved design
    $htmlMessage = '
    <!DOCTYPE html>
    <html lang="fa" dir="rtl">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>' . htmlspecialchars($subject) . '</title>
        <style>
            body { 
                font-family: "Vazirmatn", "Tahoma", Arial, sans-serif; 
                line-height: 1.6; 
                color: #333; 
                margin: 0; 
                padding: 0; 
                background-color: #f4f4f4;
            }
            .container { 
                max-width: 600px; 
                margin: 20px auto; 
                background: white; 
                border-radius: 12px; 
                overflow: hidden; 
                box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            }
            .header { 
                background: linear-gradient(135deg, #041c3f 0%, #c5912c 100%); 
                color: white; 
                padding: 30px 20px; 
                text-align: center; 
            }
            .header h1 { 
                margin: 0; 
                font-size: 24px; 
                font-weight: 700;
            }
            .header p { 
                margin: 10px 0 0 0; 
                opacity: 0.9; 
                font-size: 16px;
            }
            .content { 
                padding: 30px 20px; 
                background: white;
            }
            .info-row {
                display: flex;
                justify-content: space-between;
                align-items: center;
                padding: 12px 0;
                border-bottom: 1px solid #eee;
            }
            .info-row:last-child {
                border-bottom: none;
            }
            .info-label {
                font-weight: 600;
                color: #555;
                min-width: 120px;
            }
            .info-value {
                color: #333;
                text-align: left;
            }
            .priority-badge { 
                display: inline-block; 
                padding: 6px 12px; 
                border-radius: 20px; 
                color: white; 
                font-size: 12px; 
                font-weight: 600;
            }
            .description-box {
                background: #f8f9fa;
                border: 1px solid #e9ecef;
                border-radius: 8px;
                padding: 15px;
                margin: 15px 0;
                line-height: 1.8;
            }
            .footer { 
                text-align: center; 
                padding: 20px; 
                background: #f8f9fa; 
                color: #666; 
                font-size: 14px; 
                border-top: 1px solid #eee;
            }
            .footer a {
                color: #041c3f;
                text-decoration: none;
            }
            .footer a:hover {
                text-decoration: underline;
            }
            .timestamp {
                background: rgba(4, 28, 63, 0.1);
                border: 1px solid #041c3f;
                border-radius: 6px;
                padding: 10px;
                margin: 15px 0;
                text-align: center;
                color: #041c3f;
                font-size: 14px;
            }
        </style>
    </head>
    <body>
        <div class="container">
            <div class="header">
                <h1>' . SITE_NAME . '</h1>
                <p>' . htmlspecialchars($subject) . '</p>
            </div>
            <div class="content">
                ' . $message . '
                <div class="timestamp">
                    📅 تاریخ ارسال: ' . date('Y/m/d H:i:s') . '
                </div>
            </div>
            <div class="footer">
                <p>این ایمیل از سیستم ' . SITE_NAME . ' ارسال شده است</p>
                <p>🌐 آدرس سایت: <a href="' . SITE_URL . '">' . SITE_URL . '</a></p>
                <p>📧 پشتیبانی: <a href="mailto:' . ADMIN_EMAIL . '">' . ADMIN_EMAIL . '</a></p>
            </div>
        </div>
    </body>
    </html>';
    
    // Try to use SMTP if available
    if (file_exists(__DIR__ . '/smtp-config.php')) {
        require_once __DIR__ . '/smtp-config.php';
        if (function_exists('sendEmailWithFallback')) {
            return sendEmailWithFallback($to, $subject, $htmlMessage, $replyTo, $attachmentPath);
        }
    }
    
    // Fallback to PHP mail function
    return mail($to, $subject, $htmlMessage, $headers);
}

// Send Notification Email - ارسال ایمیل اطلاع‌رسانی
function sendNotificationEmail($type, $data) {
    $subject = '';
    $message = '';
    
    switch ($type) {
        case 'bug_report':
            $subject = '🐛 گزارش باگ جدید - ' . SITE_NAME;
            $attachmentSection = '';
            if (!empty($data['attachment_path'])) {
                $attachmentPath = $data['attachment_path'];
                $fullPath = __DIR__ . '/../' . $attachmentPath;
                error_log("Checking attachment: $attachmentPath | Full path: $fullPath | Exists: " . (file_exists($fullPath) ? 'yes' : 'no'));
                
                if (file_exists($fullPath)) {
                    $imageUrl = SITE_URL . 'backend/' . $attachmentPath;
                    $attachmentSection = '
                    <div style="margin-top: 20px;">
                        <div class="info-label" style="margin-bottom: 10px; font-weight: 600; color: #333;">📷 تصویر ضمیمه:</div>
                        <div style="padding: 1rem; background: #f8f9fa; border-radius: 0.5rem; border: 1px solid #dee2e6; text-align: center;">
                            <img src="' . htmlspecialchars($imageUrl) . '" alt="تصویر گزارش باگ" style="max-width: 100%; max-height: 500px; border-radius: 0.5rem; display: block; margin: 0 auto; border: 2px solid #041c3f;">
                            <br>
                            <div style="display: flex; gap: 0.5rem; justify-content: center; flex-wrap: wrap; margin-top: 0.5rem;">
                                <a href="' . htmlspecialchars($imageUrl) . '" target="_blank" style="color: white; text-decoration: none; padding: 0.5rem 1rem; background: #041c3f; border-radius: 0.5rem; display: inline-block; font-weight: 600;">🔗 مشاهده تصویر در اندازه کامل</a>
                                <a href="' . htmlspecialchars($imageUrl) . '" download style="color: white; text-decoration: none; padding: 0.5rem 1rem; background: #c5912c; border-radius: 0.5rem; display: inline-block; font-weight: 600;">💾 دانلود تصویر</a>
                            </div>
                        </div>
                    </div>';
                } else {
                    error_log("Attachment file not found: $fullPath");
                }
            } else {
                error_log("No attachment_path in email data");
            }
            $message = '
            <h3 style="color: #e74c3c; margin-bottom: 20px;">🐛 گزارش باگ جدید دریافت شد</h3>
            
            <div class="info-row">
                <span class="info-label">👤 نام:</span>
                <span class="info-value">' . htmlspecialchars($data['name'], ENT_QUOTES, 'UTF-8') . '</span>
            </div>
            
            <div class="info-row">
                <span class="info-label">📧 ایمیل:</span>
                <span class="info-value">' . htmlspecialchars($data['email'], ENT_QUOTES, 'UTF-8') . '</span>
            </div>
            
            <div class="info-row">
                <span class="info-label">📝 موضوع:</span>
                <span class="info-value">' . htmlspecialchars($data['subject'], ENT_QUOTES, 'UTF-8') . '</span>
            </div>
            
            <div class="info-row">
                <span class="info-label">⚡ اولویت:</span>
                <span class="info-value">
                    <span class="priority-badge" style="background-color: ' . getPriorityColor($data['priority']) . '">' . getPriorityLabel($data['priority']) . '</span>
                </span>
            </div>
            
            <div style="margin-top: 20px;">
                <div class="info-label" style="margin-bottom: 10px;">📋 توضیحات مشکل:</div>
                <div class="description-box">
                    ' . nl2br(htmlspecialchars($data['description'], ENT_QUOTES, 'UTF-8')) . '
                </div>
            </div>
            ' . $attachmentSection;
            break;
            
        case 'feature_request':
            $subject = '💡 درخواست ویژگی جدید - ' . SITE_NAME;
            $message = '
            <h3 style="color: #041c3f; margin-bottom: 20px;">💡 درخواست ویژگی جدید دریافت شد</h3>
            
            <div class="info-row">
                <span class="info-label">👤 نام:</span>
                <span class="info-value">' . htmlspecialchars($data['name'], ENT_QUOTES, 'UTF-8') . '</span>
            </div>
            
            <div class="info-row">
                <span class="info-label">📧 ایمیل:</span>
                <span class="info-value">' . htmlspecialchars($data['email'], ENT_QUOTES, 'UTF-8') . '</span>
            </div>
            
            <div class="info-row">
                <span class="info-label">💡 ویژگی:</span>
                <span class="info-value">' . htmlspecialchars($data['feature'], ENT_QUOTES, 'UTF-8') . '</span>
            </div>
            
            <div class="info-row">
                <span class="info-label">⚡ اولویت:</span>
                <span class="info-value">
                    <span class="priority-badge" style="background-color: ' . getPriorityColor($data['priority']) . '">' . getPriorityLabel($data['priority']) . '</span>
                </span>
            </div>
            
            <div style="margin-top: 20px;">
                <div class="info-label" style="margin-bottom: 10px;">📋 توضیحات ویژگی:</div>
                <div class="description-box">
                    ' . nl2br(htmlspecialchars($data['description'], ENT_QUOTES, 'UTF-8')) . '
                </div>
            </div>';
            break;
            
        case 'security_alert':
            $subject = 'هشدار امنیتی - ' . SITE_NAME;
            $message = '
            <h3>هشدار امنیتی</h3>
            <p><strong>نوع رویداد:</strong> ' . htmlspecialchars($data['event_type']) . '</p>
            <p><strong>IP:</strong> ' . htmlspecialchars($data['ip']) . '</p>
            <p><strong>جزئیات:</strong> ' . htmlspecialchars($data['details']) . '</p>
            <p><strong>سطح خطر:</strong> <span class="priority-badge" style="background-color: ' . getPriorityColor($data['severity']) . '">' . getPriorityLabel($data['severity']) . '</span></p>
            <p><strong>تاریخ:</strong> ' . date('Y/m/d H:i:s') . '</p>';
            break;
    }
    
    if ($subject && $message) {
        $attachmentPath = isset($data['attachment_path']) ? $data['attachment_path'] : null;
        return sendEmail(ADMIN_EMAIL, $subject, $message, '', $attachmentPath);
    }
    
    return false;
}
?>
