<?php
/**
 * Database Configuration
 * این فایل به صورت خودکار توسط install.php ایجاد می‌شود
 * اگر این فایل وجود ندارد یا خالی است، لطفاً install.php را اجرا کنید
 */

class Database {
    public $host = "";
    public $database = "";
    public $username = "";
    public $password = "";
    private $conn;

    public function getConnection() {
        // Check if database is configured
        if (empty($this->host) || empty($this->database) || empty($this->username)) {
            if (php_sapi_name() !== 'cli') {
                // Check if install.lock exists
                if (!file_exists(__DIR__ . '/../install.lock')) {
                    header('Location: install.php');
                    exit;
                }
            }
            throw new Exception("دیتابیس پیکربندی نشده است. لطفاً install.php را اجرا کنید.");
        }
        
        $this->conn = null;

        try {
            $this->conn = new PDO(
                "mysql:host=" . $this->host . ";dbname=" . $this->database . ";charset=utf8mb4",
                $this->username,
                $this->password,
                [
                    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                    PDO::MYSQL_ATTR_USE_BUFFERED_QUERY => true,
                    PDO::ATTR_EMULATE_PREPARES => false
                ]
            );
            
            // Set charset explicitly after connection
            $stmt1 = $this->conn->prepare("SET NAMES utf8mb4 COLLATE utf8mb4_unicode_ci");
            $stmt1->execute();
            $stmt1->closeCursor();
            
            $stmt2 = $this->conn->prepare("SET CHARACTER SET utf8mb4");
            $stmt2->execute();
            $stmt2->closeCursor();
            
            $stmt3 = $this->conn->prepare("SET character_set_connection=utf8mb4");
            $stmt3->execute();
            $stmt3->closeCursor();
            
        } catch(PDOException $exception) {
            error_log("Connection error: " . $exception->getMessage());
            error_log("Connection error code: " . $exception->getCode());
            throw new PDOException("خطا در اتصال به دیتابیس: " . $exception->getMessage(), $exception->getCode());
        }

        return $this->conn;
    }
}
?>
