<?php
// API endpoint to get system settings for frontend
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

// Handle preflight requests
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

require_once '../config/database.php';
require_once '../includes/functions.php';

try {
    $db = new Database();
    $conn = $db->getConnection();
    
    // Get all system settings
    $query = "SELECT setting_key, setting_value FROM system_settings";
    $stmt = $conn->query($query);
    $settings = [];
    
    while ($row = $stmt->fetch()) {
        $settings[$row['setting_key']] = $row['setting_value'];
    }
    
    // Set default values for missing settings
    $defaults = [
        'site_name' => 'Gavahito Admin Panel',
        'site_url' => 'https://gavahito.ir/',
        'admin_email' => 'info@gavahito.ir',
        'maintenance_mode' => '0',
        'maintenance_message' => 'سیستم در حال نگهداری است. لطفاً کمی صبر کنید.',
        'favicon_path' => '',
        'enable_recaptcha' => '1',
        'rate_limit_per_hour' => '5',
        'session_timeout_minutes' => '30',
        'max_login_attempts' => '5',
        'lockout_duration_minutes' => '15',
        'password_min_length' => '8',
        'require_strong_password' => '1',
        '2fa_enabled' => '0',
        'email_notifications' => '1',
        'auto_logout_minutes' => '30',
        'backup_enabled' => '0',
        'backup_frequency' => 'daily',
        'log_retention_days' => '30',
        'enable_xss_protection' => '1',
        'enable_sql_injection_protection' => '1'
    ];
    
    // Merge settings with defaults
    $finalSettings = array_merge($defaults, $settings);
    
    // Add favicon URL if exists
    if (!empty($finalSettings['favicon_path'])) {
        $faviconPath = '../' . $finalSettings['favicon_path'];
        if (file_exists($faviconPath)) {
            $finalSettings['favicon_url'] = $finalSettings['favicon_path'];
        } else {
            $finalSettings['favicon_url'] = '';
        }
    } else {
        $finalSettings['favicon_url'] = '';
    }
    
    // Remove sensitive information before sending to frontend
    unset($finalSettings['admin_email']);
    
    // Return settings as JSON
    echo json_encode([
        'success' => true,
        'data' => $finalSettings,
        'timestamp' => date('Y-m-d H:i:s')
    ], JSON_UNESCAPED_UNICODE);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'error' => 'خطا در دریافت تنظیمات',
        'message' => $e->getMessage(),
        'timestamp' => date('Y-m-d H:i:s')
    ], JSON_UNESCAPED_UNICODE);
}
?>
